﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using usbLan;
using System.IO;
using System.IO.Ports;
using System.Net.Sockets;
using System.Net;
using System.Net.NetworkInformation;

namespace TestDll.controlInterface
{
    public partial class multichannelPhaseShifterForm : Form
    {
        SerialPort usbPort = null;
        Socket tcpConnect = null;
        string[] e2Strings = { "E1", "E2", "E3", "E4", "E5" };
        public multichannelPhaseShifterForm()
        {
            InitializeComponent();
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
            btRefreshCOMx_Click(null, null);
            btRefreshLocalIP_Click(null, null);
            cbbChannel.Items.Clear();
            cbbChannel.Items.Add("All");
            for(int i=1;i<=8;i++)
            {
                cbbChannel.Items.Add("C" + i.ToString());
            }
            cbbChannel.SelectedIndex = 0;
        }
        private void comboBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = true;
        }
        private void btRefreshCOMx_Click(object sender, EventArgs e)
        {
            cbbCOMx.Items.Clear();
            string[] comPorts = commonModule.getCOMnames();
            for (int i = 0; i < comPorts.Length; i++)
            {
                cbbCOMx.Items.Add(comPorts[i]);
            }
            cbbCOMx.Text = comPorts[0];
        }
        private void btRefreshLocalIP_Click(object sender, EventArgs e)
        {
            cbbLocalIP.Items.Clear();
            string[] localIPs = commonModule.getLocalIPs();
            for (int i = 0; i < localIPs.Length; i++)
            {
                cbbLocalIP.Items.Add(localIPs[i]);
            }
            cbbLocalIP.Text = localIPs[0];
        }
        private void rbUSB_Click(object sender, EventArgs e)
        {
            rbUSB.Checked = true;
            gbUSBport.Enabled = true;
            gbLANport.Enabled = false;
        }
        private void rbLan_Click(object sender, EventArgs e)
        {
            rbLan.Checked = true;
            gbUSBport.Enabled = false;
            gbLANport.Enabled = true;
        }
        private void btConnect_Click(object sender, EventArgs e)
        {
            if (rbUSB.Checked)
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        usbPort = usbLan.commonModule.openConnectUSB(cbbCOMx.Text, Convert.ToInt32(cbbBaud.Text));
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectUSB(usbPort);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                    }
                    catch
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
            else
            {
                if (btConnect.Text == "Connect Device")
                {
                    try
                    {
                        tcpConnect = usbLan.commonModule.openConnectTCP(cbbLocalIP.Text, tbDeviceIP.Text, Convert.ToInt32(nudDevicePort.Value));
                        btConnect.Text = "Close Connect";
                        btConnect.ForeColor = Color.Red;
                        btConnect.BackColor = Color.LimeGreen;
                    }
                    catch
                    {
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        MessageBox.Show("Connect failure!");
                    }
                }
                else
                {
                    try
                    {
                        usbLan.commonModule.closeConnectTCP(tcpConnect);
                        btConnect.Text = "Connect Device";
                        btConnect.ForeColor = Color.Blue;
                        btConnect.BackColor = Color.Transparent;
                    }
                    catch
                    {
                        MessageBox.Show("Close failure!");
                    }
                }
            }
        }
        private void btGetControlBits_Click(object sender, EventArgs e)
        {
            string hints = "";
            try
            {
                if(rbUSB.Checked)
                {
                    tbControlBits.Text = usbLan.multichannelPhaseShifterModule.getControlBitsUSB(usbPort,Convert.ToInt32(nudChannelNumber.Value));
                }
                else
                {
                    tbControlBits.Text = usbLan.multichannelPhaseShifterModule.getControlBitsTCP(tcpConnect, Convert.ToInt32(nudChannelNumber.Value));
                }
                hints = checkReceiveString(tbControlBits.Text,"Get Control Bits successful!");
            }
            catch
            {
                hints = "Get Control Bits failure!";
            }
            MessageBox.Show(hints);
        }
        private void btGetStepsize_Click(object sender, EventArgs e)
        {
            string hints = "";
            cbbFixedAttenuation.Items.Clear();
            cbbStartValue.Items.Clear();
            cbbStopValue.Items.Clear();
            try
            {
                if (rbUSB.Checked)
                {
                    tbStepsize.Text = usbLan.multichannelPhaseShifterModule.getStepsizeUSB(usbPort, Convert.ToInt32(nudChannelNumber.Value));
                }
                else
                {
                    tbStepsize.Text = usbLan.multichannelPhaseShifterModule.getStepsizeTCP(tcpConnect, Convert.ToInt32(nudChannelNumber.Value));
                }
                hints = checkReceiveString(tbStepsize.Text, "Get stepsize successful!");
                for(int i=0;i<Math.Pow(2,Convert.ToInt32(tbControlBits.Text));i++)
                {
                    cbbFixedAttenuation.Items.Add(i*Convert.ToDouble(tbStepsize.Text));
                    cbbStartValue.Items.Add(i*Convert.ToDouble(tbStepsize.Text));
                    cbbStopValue.Items.Add(i * Convert.ToDouble(tbStepsize.Text));
                }
                cbbFixedAttenuation.SelectedIndex = 0;
                cbbStartValue.SelectedIndex = 0;
                cbbStopValue.SelectedIndex = 1;
            }
            catch
            {
                hints = "Get stepsize failure!";
            }
            MessageBox.Show(hints);
        }
        private void btSetFixedPhaseValue_Click(object sender, EventArgs e)
        {
            string hints = "";
            bool channel1 = false, channel2 = false, channel3 = false, channel4 = false, channel5 = false, channel6 = false, channel7 = false, channel8 = false;
            switch (Convert.ToInt32(nudChannelNumber.Value))
            {
                case 1:
                    channel1 = true;
                    break;
                case 2:
                    channel2 = true;
                    break;
                case 3:
                    channel3 = true;
                    break;
                case 4:
                    channel4 = true;
                    break;
                case 5:
                    channel5 = true;
                    break;
                case 6:
                    channel6 = true;
                    break;
                case 7:
                    channel7 = true;
                    break;
                case 8:
                    channel8 = true;
                    break;
                default:
                    break;
            }
            try
            {
                if (rbUSB.Checked)
                {
                    tbReceiveFixed.Text = usbLan.multichannelPhaseShifterModule.setFixedStepUSB(usbPort, Convert.ToInt32(nudChannelNumber.Value), cbbFixedAttenuation.SelectedIndex);
                    tbReceiveFixed.Text += "\r\n" + usbLan.multichannelPhaseShifterModule.startFixedUSB(usbPort, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8);
                }
                else
                {
                    tbReceiveFixed.Text = usbLan.multichannelPhaseShifterModule.setFixedStepTCP(tcpConnect, Convert.ToInt32(nudChannelNumber.Value), cbbFixedAttenuation.SelectedIndex);
                    tbReceiveFixed.Text += "\r\n" + usbLan.multichannelPhaseShifterModule.startFixedUSB(usbPort, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8);
                }
                hints = checkReceiveString(tbReceiveFixed.Text, "Set fixed phase value successful!");
            }
            catch
            {
                hints = "Set fixed phase value failure!";
            }
            MessageBox.Show(hints);
        }
        private void btStartCycle_Click(object sender, EventArgs e)
        {
            string hints = "";
            bool channel1=false,channel2=false,channel3=false,channel4=false,channel5=false,channel6=false,channel7=false,channel8=false;
            switch(Convert.ToInt32(nudChannelNumber.Value))
            {
                case 1:
                    channel1 = true;
                    break;
                case 2:
                    channel2 = true;
                    break;
                case 3:
                    channel3 = true;
                    break;
                case 4:
                    channel4 = true;
                    break;
                case 5:
                    channel5 = true;
                    break;
                case 6:
                    channel6 = true;
                    break;
                case 7:
                    channel7 = true;
                    break;
                case 8:
                    channel8 = true;
                    break;
                default:
                    break;
            }
            try
            {
                if (rbUSB.Checked)
                {
                    tbReceiveCycle.Text = usbLan.multichannelPhaseShifterModule.setCycleUSB(usbPort, Convert.ToInt32(nudChannelNumber.Value), cbbStartValue.SelectedIndex,
                        cbbStopValue.SelectedIndex, Convert.ToInt32(nudMultiStep.Value), Convert.ToDouble(nudDwellTime.Value), Convert.ToInt32(nudCount.Value));
                    tbReceiveCycle.Text += "\r\n" + usbLan.multichannelPhaseShifterModule.startCycleUSB(usbPort, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8);
                }
                else
                {
                    tbReceiveCycle.Text = usbLan.multichannelPhaseShifterModule.setCycleTCP(tcpConnect, Convert.ToInt32(nudChannelNumber.Value), cbbStartValue.SelectedIndex,
                        cbbStopValue.SelectedIndex, Convert.ToInt32(nudMultiStep.Value), Convert.ToDouble(nudDwellTime.Value), Convert.ToInt32(nudCount.Value));
                    tbReceiveCycle.Text += "\r\n" + usbLan.multichannelPhaseShifterModule.startCycleTCP(tcpConnect, channel1, channel2, channel3, channel4, channel5, channel6, channel7, channel8);
                }
                hints = checkReceiveString(tbReceiveCycle.Text, "Set cycle successful!");
            }
            catch
            {
                hints = "Set cycle failure!";
            }
            MessageBox.Show(hints);
        }
        private void btQuery_Click(object sender, EventArgs e)
        {
            string hints = "";
            try
            {
                if (rbInformation.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.commonModule.getProductInformationUSB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.commonModule.getProductInformationTCP(tcpConnect);
                    }
                }
                else if (rbMAC.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.commonModule.getMAC_USB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.commonModule.getMAC_TCP(tcpConnect);
                    }
                }
                else if (rbProtect.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getProtectionStatusUSB(usbPort);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getProtectionStatusTCP(tcpConnect);
                    }
                }
                else if (rbBits.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getControlBitsUSB(usbPort, cbbChannel.SelectedIndex);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getControlBitsTCP(tcpConnect, cbbChannel.SelectedIndex);
                    }
                }
                else if (rbStep.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getFixedStepUSB(usbPort, cbbChannel.SelectedIndex);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getFixedStepTCP(tcpConnect, cbbChannel.SelectedIndex);
                    }
                }
                else if (rbStepsize.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getStepsizeUSB(usbPort, cbbChannel.SelectedIndex);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getStepsizeTCP(tcpConnect, cbbChannel.SelectedIndex);
                    }
                }
                else if (rbStatus.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getStatusUSB(usbPort, cbbChannel.SelectedIndex);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getStatusTCP(tcpConnect, cbbChannel.SelectedIndex);
                    }
                }
                else if (rbLoopset.Checked)
                {
                    if (rbUSB.Checked)
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getCycleSettingsUSB(usbPort, cbbChannel.SelectedIndex);
                    }
                    else
                    {
                        tbRecStr.Text = usbLan.multichannelPhaseShifterModule.getCycleSettingsTCP(tcpConnect, cbbChannel.SelectedIndex);
                    }
                }
                hints = checkReceiveString(tbRecStr.Text, "Query successful!");
            }
            catch
            {
                hints = "Query failure!";
            }
            MessageBox.Show(hints);
        }
        private string checkReceiveString(string recStr, string rightHints)
        {
            string hintsStr = "";
            if (Array.IndexOf(e2Strings, recStr) >= 0)
            {
                hintsStr = usbLan.commonModule.queryErrorDescription(recStr);
            }
            else
            {
                hintsStr = rightHints;
            }
            return hintsStr;
        }

    }
}
